/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.controller.GraphPresentationDialog.ChangeBackgroundColorActionListener;
import net.nooj4nlp.controller.GraphPresentationDialog.ChangeFontActionListener;
import net.nooj4nlp.controller.GraphPresentationDialog.GraphPresentationController;

public class GraphPresentationDialog
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private GraphPresentationController controller;
    private JCheckBox cbFileName;
    private JCheckBox cbFrame;
    private JCheckBox cbDirName;
    private JCheckBox cbAuthor;
    private JCheckBox cbDate;
    private JCheckBox cbInstitution;
    private JCheckBox cbCircleEmptyNodes;
    private JLabel labelInput;
    private JLabel labelOutput;
    private JLabel labelCom;
    private JButton buttonBackground;
    private JButton buttonVariables;
    private JButton buttonForeground;
    private JButton buttonAuxiliary;
    private JButton buttonSelection;
    private JButton buttonComments;

    public GraphPresentationDialog(GrammarEditorShellController grammarController) {
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setClosable(false);
        this.setResizable(true);
        this.setTitle("Graph Presentation");
        this.setBounds(75, 75, 540, 400);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("ins 4", "[260:280:300][grow]", "[100][][][][]"));
        JPanel panelText = new JPanel();
        panelText.setBorder(new TitledBorder(null, "Text", 4, 2, null, null));
        panelText.setLayout((LayoutManager)new MigLayout("ins 4", "[][]", "[][][]"));
        this.getContentPane().add((Component)panelText, "cell 0 0, grow, height 90");
        Dimension panelButtonSize = new Dimension(25, 15);
        JButton buttonInput = new JButton("Input");
        buttonInput.setPreferredSize(panelButtonSize);
        buttonInput.setActionCommand("Input");
        panelText.add((Component)buttonInput, "cell 0 0, gaptop 5, grow");
        this.labelInput = new JLabel("Font");
        panelText.add((Component)this.labelInput, "cell 1 0, alignx left, gaptop 5, gapleft 5, grow");
        JButton buttonOutput = new JButton("Output");
        buttonOutput.setPreferredSize(panelButtonSize);
        buttonOutput.setActionCommand("Output");
        panelText.add((Component)buttonOutput, "cell 0 1, gaptop 5, grow");
        this.labelOutput = new JLabel("Font");
        panelText.add((Component)this.labelOutput, "cell 1 1, alignx left, gaptop 5, gapleft 5, grow");
        JButton buttonCom = new JButton("Com.");
        buttonCom.setPreferredSize(panelButtonSize);
        buttonCom.setActionCommand("Comment");
        panelText.add((Component)buttonCom, "cell 0 2, gaptop 5, grow");
        this.labelCom = new JLabel("Font");
        panelText.add((Component)this.labelCom, "cell 1 2, alignx left, gaptop 5, gapleft 5, grow");
        JPanel panelColors = new JPanel();
        panelColors.setBorder(new TitledBorder(null, "Colors", 4, 2, null, null));
        panelColors.setLayout((LayoutManager)new MigLayout("ins 3", "[grow][grow]", "[][][]"));
        this.getContentPane().add((Component)panelColors, "cell 1 0, gapleft 3, grow");
        this.buttonBackground = new JButton("Background");
        panelColors.add((Component)this.buttonBackground, "cell 0 0, height 28::, grow");
        this.buttonVariables = new JButton("Variables");
        panelColors.add((Component)this.buttonVariables, "cell 1 0, height 28::, gapleft 5, grow");
        this.buttonForeground = new JButton("Foreground");
        panelColors.add((Component)this.buttonForeground, "cell 0 1, height 28::, gaptop 5, grow");
        this.buttonAuxiliary = new JButton("Auxiliary terms");
        panelColors.add((Component)this.buttonAuxiliary, "cell 1 1, height 28::, gapleft 5, gaptop 5, grow");
        this.buttonSelection = new JButton("Selection");
        panelColors.add((Component)this.buttonSelection, "cell 0 2, height 28::, gaptop 5, grow");
        this.buttonComments = new JButton("Comments");
        panelColors.add((Component)this.buttonComments, "cell 1 2, height 28::, gaptop 5, gapleft 5, grow");
        JPanel panelDisplay = new JPanel();
        panelDisplay.setBorder(new TitledBorder(null, "Display", 4, 2, null, null));
        panelDisplay.setLayout((LayoutManager)new MigLayout("ins 3", "[grow][120:130:140]", "[fill][fill][fill][fill][fill]"));
        this.getContentPane().add((Component)panelDisplay, "cell 0 1, grow, span 1 4, gaptop 3");
        this.cbFileName = new JCheckBox("File name");
        panelDisplay.add((Component)this.cbFileName, "cell 0 0, alignx left");
        this.cbFrame = new JCheckBox("Frame");
        panelDisplay.add((Component)this.cbFrame, "cell 1 0, alignx left");
        this.cbDirName = new JCheckBox("Directory name");
        panelDisplay.add((Component)this.cbDirName, "cell 0 1, alignx left");
        this.cbAuthor = new JCheckBox("Author");
        panelDisplay.add((Component)this.cbAuthor, "cell 1 1, alignx left");
        this.cbDate = new JCheckBox("Date");
        panelDisplay.add((Component)this.cbDate, "cell 0 2, alignx left");
        this.cbInstitution = new JCheckBox("Institution");
        panelDisplay.add((Component)this.cbInstitution, "cell 1 2, alignx left");
        this.cbCircleEmptyNodes = new JCheckBox("Circle Empty nodes");
        panelDisplay.add((Component)this.cbCircleEmptyNodes, "cell 0 3, alignx left");
        JCheckBox cbMaxDisplTerms = new JCheckBox("Max. Displayed terms");
        panelDisplay.add((Component)cbMaxDisplTerms, "cell 0 4, alignx left");
        JTextField tfTerms = new JTextField("4");
        tfTerms.setColumns(4);
        tfTerms.setHorizontalAlignment(4);
        tfTerms.setEnabled(true);
        panelDisplay.add((Component)tfTerms, "cell 1 4, alignx left, gapleft 30");
        Dimension buttonSize = new Dimension(140, 24);
        JButton buttonGetDefault = new JButton("Get Default");
        buttonGetDefault.setPreferredSize(buttonSize);
        this.getContentPane().add((Component)buttonGetDefault, "cell 1 1, gaptop 13, gapright 7, alignx right");
        JButton buttonSetDefault = new JButton("Set Default");
        buttonSetDefault.setPreferredSize(buttonSize);
        this.getContentPane().add((Component)buttonSetDefault, "cell 1 2, gaptop 13, gapright 7, alignx right");
        JButton buttonApply = new JButton("Apply");
        buttonApply.setPreferredSize(buttonSize);
        this.getContentPane().add((Component)buttonApply, "cell 1 3, gaptop 13, gapright 7, alignx right");
        JButton buttonClose = new JButton("Close");
        buttonClose.setPreferredSize(buttonSize);
        this.getContentPane().add((Component)buttonClose, "cell 1 4, gaptop 11, gapright 7, alignx right");
        ChangeBackgroundColorActionListener changeButtonBackgroundColorListener = new ChangeBackgroundColorActionListener();
        this.buttonAuxiliary.addActionListener(changeButtonBackgroundColorListener);
        this.buttonBackground.addActionListener(changeButtonBackgroundColorListener);
        this.buttonComments.addActionListener(changeButtonBackgroundColorListener);
        this.buttonForeground.addActionListener(changeButtonBackgroundColorListener);
        this.buttonSelection.addActionListener(changeButtonBackgroundColorListener);
        this.buttonVariables.addActionListener(changeButtonBackgroundColorListener);
        this.controller = new GraphPresentationController(this, grammarController);
        ChangeFontActionListener changeFontListener = new ChangeFontActionListener(this.controller);
        buttonInput.addActionListener(changeFontListener);
        buttonOutput.addActionListener(changeFontListener);
        buttonCom.addActionListener(changeFontListener);
        buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphPresentationDialog.this.controller.apply();
            }
        });
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphPresentationDialog.this.controller.close();
            }
        });
        buttonGetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphPresentationDialog.this.controller.reset();
            }
        });
        buttonSetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphPresentationDialog.this.controller.setDefault();
            }
        });
    }

    public GraphPresentationController getController() {
        return this.controller;
    }

    public JCheckBox getCbFileName() {
        return this.cbFileName;
    }

    public JCheckBox getCbFrame() {
        return this.cbFrame;
    }

    public JCheckBox getCbDirName() {
        return this.cbDirName;
    }

    public JCheckBox getCbAuthor() {
        return this.cbAuthor;
    }

    public JCheckBox getCbDate() {
        return this.cbDate;
    }

    public JCheckBox getCbInstitution() {
        return this.cbInstitution;
    }

    public JCheckBox getCbCircleEmptyNodes() {
        return this.cbCircleEmptyNodes;
    }

    public JLabel getLabelInput() {
        return this.labelInput;
    }

    public JLabel getLabelOutput() {
        return this.labelOutput;
    }

    public JLabel getLabelCom() {
        return this.labelCom;
    }

    public JButton getButtonBackground() {
        return this.buttonBackground;
    }

    public JButton getButtonVariables() {
        return this.buttonVariables;
    }

    public JButton getButtonForeground() {
        return this.buttonForeground;
    }

    public JButton getButtonAuxiliary() {
        return this.buttonAuxiliary;
    }

    public JButton getButtonSelection() {
        return this.buttonSelection;
    }

    public JButton getButtonComments() {
        return this.buttonComments;
    }
}

